/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.cobalt.internal.doubles;

import cc.tweaked.cobalt.internal.doubles.Assert;
import cc.tweaked.cobalt.internal.doubles.UnsignedValues;
import org.checkerframework.checker.signedness.qual.Unsigned;

record DiyFp(@Unsigned long significand, int exponent) {
    public static final int SIGNIFICAND_SIZE = 64;

    public static DiyFp minus(DiyFp a, DiyFp b) {
        Assert.requireArg(a.exponent == b.exponent, "exponents must match");
        Assert.requireArg(UnsignedValues.ulongGE(a.significand, b.significand), "other.f must be greater than this.f");
        return new DiyFp(a.significand - b.significand, a.exponent);
    }

    public static DiyFp times(DiyFp left, DiyFp right) {
        @Unsigned long otherF = right.significand;
        long kM32 = 0xFFFFFFFFL;
        long a = left.significand >>> 32;
        long b = left.significand & 0xFFFFFFFFL;
        long c = otherF >>> 32;
        long d = otherF & 0xFFFFFFFFL;
        long ac = a * c;
        long bc = b * c;
        long ad = a * d;
        long bd = b * d;
        long tmp = (bd >>> 32) + (ad & 0xFFFFFFFFL) + (bc & 0xFFFFFFFFL) + 0x80000000L;
        return new DiyFp(ac + (ad >>> 32) + (bc >>> 32) + (tmp >>> 32), left.exponent + right.exponent + 64);
    }
}

